<?php
/*
 * Plugin Name: Beezer Woocommerce Extension
 * Plugin URI: https://www.beezer.com/
 * Description: Beezer Woocommerce Extension to enable the Woocommerce checkout in Beezer apps
 * Author: Beezer
 * Version: 1.0
 * Author URI: https://www.beezer.com/
 */
if (! class_exists("Beezer")) {

    class Beezer
    {

        /**
         *
         * @var Beezer Single instance of class
         */
        public static function instance()
        {
            return new self();
        }

        protected function __construct()
        {
            $this->define_constants();
            $this->loadFiles();
        }

        public function define_constants()
        {
            $this->define('BZR_PLUGIN_FILE', __FILE__);
            $this->define('BZR_PLUGIN_BASENAME', plugin_basename(__FILE__));
            $this->define('BZR_PLUGIN_DIR', dirname(__FILE__));
        }

        public function plugin_url($uri = '')
        {
            $url = get_template_directory_uri() . '/plugins';

            if ($uri) {
                $url .= '/' . $uri;
            }
            return $url;
        }

        protected function define($name, $value)
        {
            if (! defined($name)) {
                define($name, $value);
            }
        }

        protected function loadFiles()
        {
            require_once BZR_PLUGIN_DIR . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'checkout.php';
        }
    }
}

function bzr_admin_notice()
{
    if (isset($_SESSION['notice_message'])) {
        $msg = $_SESSION['notice_message'];
        unset($_SESSION['notice_message']);

        ?>
<div class="notice notice-success is-dismissible">
	<p><?php echo $msg ?></p>
</div>
<?php
    }
}
add_action('admin_notices', 'bzr_admin_notice');

Beezer::instance();

